//
//  MCIdleManager.h
//  MCFoundation
//
//  Created by Brent Gulanowski on 04/07/07.
//  Copyright 2007 Marketcircle, Inc. All rights reserved.
//
//  Description


#import <Foundation/Foundation.h>


// notification names
extern NSString *MCIdleManagerSystemDidBecomeIdle;
extern NSString *MCIdleManagerSystemDidBecomeActive;


@interface MCIdleManager : NSObject {

	NSNotificationCenter *idleNotifier;
	NSTimeInterval defaultIdleThreshold;
	
	NSMutableDictionary *thresholdIndex; // listener -> threshold
	NSMutableDictionary *reverseIndex; // threshold -> notifier containing listeners
}

+ (MCIdleManager *)defaultIdleManager;

- (id)initWithDefaultIdleThreshold:(NSTimeInterval)seconds;
- (NSTimeInterval)defaultIdleThreshold;
- (void)setDefaultIdleThreshold:(NSTimeInterval)seconds;
- (NSNotificationCenter *)idleNotifier;

- (void)addListener:(id)anObject;
- (void)addListener:(id)anObject threshold:(NSTimeInterval)seconds;
- (void)removeListener:(id)anObject;
- (void)setIdleThreshold:(NSTimeInterval)seconds forListener:(id)anObject;
- (NSTimeInterval)idleThresholdForListener:(id)anObject;
@end


@interface NSObject (MCIdleListening)
-(void)systemDidBecomeIdle:(NSNotification *)aNote;
-(void)systemDidBecomeActive:(NSNotification *)aNote;
@end
